package org.seasar.hibernate.dao.criteria;

import net.sf.hibernate.Criteria;
import net.sf.hibernate.expression.Order;

/**
 * @author kenichi_okazaki
 *
 */
public class OrderByCriteriaCommand extends abstractCriteriaCommand {

	/**
	 * @param fieldName
	 * @param dtoFieldName
	 */
	public OrderByCriteriaCommand(String fieldName, String dtoFieldName) {
		super(fieldName, dtoFieldName);
	}

	/* (non-Javadoc)
	 * @see org.seasar.hibernate.dao.criteria.CriteriaCommand#getCriteria(net.sf.hibernate.Criteria, java.lang.Object)
	 */
	public Criteria getCriteria(Criteria criteria,Object value) {
		String[] args = ((String)value).split(" ");

		if(args.length == 2 && args[1].toLowerCase().equals("desc") ){
			return criteria.addOrder( Order.desc(args[0] ) );
		}else{
			return criteria.addOrder( Order.asc(args[0] ) );
		}
		
	}


}
