package test.org.seasar.hibernate.dao.impl;

import org.seasar.extension.unit.S2TestCase;
import org.seasar.hibernate.HibernateRuntimeException;
import org.seasar.hibernate.S2SessionFactory;

import examples.hibernate.dao.EmployeeAutoDao;
import examples.hibernate.entity.Employee;

public class EmployeeDao2Test extends S2TestCase {

	private EmployeeAutoDao dao_;
	/**
	 * Constructor for S2SessionFactoryImplTest.
	 * @param arg0
	 */
	public EmployeeDao2Test(String arg0) {
		super(arg0);
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();

		include("examples/hibernate/client/EmployeeAutoDao.dicon");
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}




	public void testSaveTx(){
		Employee emp = new Employee();
		emp.setEmpno( new Integer(7900));
		emp.setEname("test");
		emp.setDeptno( new Integer(10) );
					
		dao_.save( emp ) ;
		
	}


	public void testService(){
        try {
            EmployeeService service = (EmployeeService)getContainer().getComponent(EmployeeService.class);
            service.execute();
            fail();
        }
        catch (HibernateRuntimeException expected) {
        }
	}

	
	
}