package test.org.seasar.hibernate3.dao.impl;

import org.seasar.extension.unit.S2TestCase;

import examples.hibernate.dao.DepartmentAutoDao;
import examples.hibernate.entity.Department;

public class DepartmentDaoTest extends S2TestCase {

	private DepartmentAutoDao dao_;
	/**
	 * Constructor for S2SessionFactoryImplTest.
	 * @param arg0
	 */
	public DepartmentDaoTest(String arg0) {
		super(arg0);
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();

		include("examples/hibernate3/client/DepartmentAutoDao.dicon");
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}


	public void testGetDepartmentByDeptno() {
		Department dept = dao_.getDepartmentByDeptno( (int)30 ) ;

		assertEquals("1",6,dept.getEmployee().size() );	

	}

	
	public void testGetDeptByDeptno() {
		Department dept = dao_.getDept( (short)30 ) ;

		assertEquals("100",6,dept.getEmployee().size() );	

	}
	
	public void testGetDeptName() {
		String deptName = dao_.getDeptName( (short)30 ) ;

		assertEquals("100","SALES",deptName );	

	}
	
}