package test.org.seasar.hibernate3.dao.impl;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;

import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.unit.S2TestCase;

import examples.hibernate.dao.EmployeeAutoDao;
import examples.hibernate.dto.EmployeeSimpleDto;
import examples.hibernate.entity.Employee;

public class EmployeeDaoSimpleDtoTest extends S2TestCase {

	private EmployeeAutoDao dao_;
	/**
	 * Constructor for S2SessionFactoryImplTest.
	 * @param arg0
	 */
	public EmployeeDaoSimpleDtoTest(String arg0) {
		super(arg0);
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();

		include("examples/hibernate3/client/EmployeeAutoDao.dicon");
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}


	public void testGetEmployeeByDtoAuto_Empno(){
		EmployeeSimpleDto emp = new EmployeeSimpleDto();
		emp.setEmpno(new Integer(7369) );

		List ret = dao_.getEmployeeByEmployeeSimpleDtoAuto(emp);

		assertEquals(1,ret.size() );
		assertEquals("SMITH", ((Employee)ret.get(0) ).getEname()  );
	}
	
	public void testGetEmployeeByDtoAuto_Ename(){
		EmployeeSimpleDto emp = new EmployeeSimpleDto();
		emp.setEname("SMITH" );

		List ret = dao_.getEmployeeByEmployeeSimpleDtoAuto(emp);

		assertEquals(1,ret.size() );
		assertEquals( 7369 , ((Employee)ret.get(0) ).getEmpno().intValue()  );
	}
	
	public void testGetEmployeeByDtoAuto_Job(){
		EmployeeSimpleDto emp = new EmployeeSimpleDto();
		emp.setJob("MANAGER" );
		emp.setOrderBy("empno desc");
		
		List ret = dao_.getEmployeeByEmployeeSimpleDtoAuto(emp);

		DataSet expected = readXls("EMP_MANAGER.xls");
		assertEquals("1",expected,  ret);
		
	}

	public void testGetEmployeeByDtoAuto_Mgr(){
		EmployeeSimpleDto emp = new EmployeeSimpleDto();
		emp.setMgr( new Short( (short)7839 )   );
		emp.setOrderBy("empno desc");
		
		List ret = dao_.getEmployeeByEmployeeSimpleDtoAuto(emp);

		DataSet expected = readXls("EMP_MANAGER.xls");
		assertEquals("1",expected,  ret);
		
	}
	
	public void testGetEmployeeByDtoAuto_Hiredate(){
	    SimpleDateFormat sdf = new SimpleDateFormat();
	    sdf.setLenient( false );
	    sdf.applyPattern( "yyyy/MM/dd" );
	    
		EmployeeSimpleDto emp = new EmployeeSimpleDto();
		try {
			emp.setHiredate( sdf.parse("1980/12/17" )   );
		} catch (ParseException e) {
			e.printStackTrace();
		}
		emp.setOrderBy("empno desc");
		
		List ret = dao_.getEmployeeByEmployeeSimpleDtoAuto(emp);

		assertEquals(1,ret.size() );
		assertEquals("SMITH", ((Employee)ret.get(0) ).getEname()  );

	}
	
	public void testGetEmployeeByDtoAuto_Sal(){
		EmployeeSimpleDto emp = new EmployeeSimpleDto();
		emp.setSal( new BigDecimal(5000)   );
		emp.setOrderBy("empno desc");
		
		List ret = dao_.getEmployeeByEmployeeSimpleDtoAuto(emp);

		assertEquals(1,ret.size() );
		assertEquals("KING", ((Employee)ret.get(0) ).getEname()  );

	}
	
	public void testGetEmployeeByDtoAuto_Comm(){
		EmployeeSimpleDto emp = new EmployeeSimpleDto();
		emp.setComm( new Float(300)   );
		emp.setOrderBy("empno desc");
		
		List ret = dao_.getEmployeeByEmployeeSimpleDtoAuto(emp);

		assertEquals(1,ret.size() );
		assertEquals("ALLEN", ((Employee)ret.get(0) ).getEname()  );

	}
	
	
	public void testGetEmployeeByDtoAuto_Deptno(){
		EmployeeSimpleDto emp = new EmployeeSimpleDto();
		emp.setDeptno( new Integer(20)   );
		emp.setOrderBy("empno desc");
		
		List ret = dao_.getEmployeeByEmployeeSimpleDtoAuto(emp);

		assertEquals(4,ret.size() );

	}
	
	
	public void testGetEmployeeByDtoAuto_JobAndDeptno(){
		EmployeeSimpleDto emp = new EmployeeSimpleDto();

		emp.setJob( "MANAGER"   );
		emp.setDeptno( new Integer(20)   );
		emp.setOrderBy("empno desc");
		
		List ret = dao_.getEmployeeByEmployeeSimpleDtoAuto(emp);

		assertEquals(1,ret.size() );
		assertEquals("JONES", ((Employee)ret.get(0) ).getEname()  );
	}
	
	
	
	
}