package org.seasar.boot;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public final class Bootstrap implements FilenameFilter {
	
	private String _className;
	private String[] _args;
	private ClassLoader _classLoader;
	
	public Bootstrap(String className, String[] args) throws Exception {
		_className = className;
		_args = args;
		List urls = new ArrayList();
		appendClassesURL(urls);
		appendJarURL(urls);
		ClassLoader parent = ClassLoader.getSystemClassLoader();
		_classLoader = new URLClassLoader((URL[])urls.toArray(new URL[urls.size()]), parent);
		Thread.currentThread().setContextClassLoader(_classLoader);
	}

    public static void main(String args[]) {
        try {
            String className = args[0];
            String[] args2 = new String[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
            	args2[i - 1] = args[i];
            }
            Bootstrap bootstrap = new Bootstrap(className, args2);
            bootstrap.start();
            System.exit(0);
        } catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    public static String getHome() {
        return System.getProperty("seasar.home", "..");
    }
    
	public void appendClassesURL(final List urls) throws Exception {
		File classesDir = new File(getHome() + File.separator + "classes");
		if (classesDir.exists()) {
			urls.add(classesDir.toURL());
		}
	}
	
	public void appendJarURL(final List urls) throws Exception {
		File libDir = new File(getHome() + File.separator + "lib");
		File[] files = libDir.listFiles(this);
		if (files == null) {
			return;
		}
		for (int i = 0; i < files.length; ++i) {
			//urls.add(new URL("file", null, files[i].getCanonicalPath()));
			urls.add(files[i].toURL());
		}
	}
	
	public boolean accept(File dir, String name) {
		String ext = "";
		int extPos = name.lastIndexOf(".");
		if (extPos >= 0) {
			ext = name.substring(extPos + 1);
		}
		return "jar".equalsIgnoreCase(ext) || "zip".equalsIgnoreCase(ext);
	}

    public void start() throws Exception {
        Class clazz = _classLoader.loadClass(_className);
        Method main = clazz.getMethod("main", new Class[]{(new String[0]).getClass()});
        main.invoke(null, new Object[]{_args});
    }

}
