package org.seasar.mbean;

import java.util.Properties;

import javax.management.NotificationListener;

import org.seasar.log.Logger;
import org.seasar.system.JMXService;
import org.seasar.system.JMXUtil;
import org.seasar.system.Lifecycle;
import org.seasar.util.Reflector;
import org.seasar.util.SeasarRuntimeException;

public final class NotificationListenerContainer implements Lifecycle {

	private static final Logger _logger = Logger.getLogger(NotificationListenerContainer.class);
	private String _className;
	private String _targetName;
	private Properties _properties = new Properties();
	private NotificationListener _notificationListener;
	
	public NotificationListenerContainer(String className, String targetName) {
		if (className == null) {
			throw new SeasarRuntimeException("ESSR0007", new Object[]{"className"});
		}
		_className = className;
		if (targetName == null) {
			throw new SeasarRuntimeException("ESSR0007", new Object[]{"targetName"});
		}
		_targetName = targetName;
	}
	
	public void setProperty(String name, String value) {
		_properties.setProperty(name, value);
	}
	
	public NotificationListener getNotificationListener() {
		return _notificationListener;
	}
	
	public void start() {
		try {
			_notificationListener = (NotificationListener) Reflector.newInstance(_className);
			Reflector.setProperties(_notificationListener, _properties);
			if (_notificationListener instanceof Lifecycle) {
				((Lifecycle) _notificationListener).start();
			}
			JMXService.addNotificationListener(
				JMXUtil.getMBeanName(_targetName), _notificationListener);
		} catch (Throwable t) {
			_logger.log(t);
		}
	}
	
	public void stop() {
		try {
			JMXService.removeNotificationListener(
				JMXUtil.getMBeanName(_targetName), _notificationListener);
			if (_notificationListener instanceof Lifecycle) {
				((Lifecycle) _notificationListener).stop();
			}
		} catch (Throwable t) {
			_logger.log(t);
		} finally {
			_notificationListener = null;
		}
	}
}
