package org.seasar.mbean;

import java.util.Properties;

import javax.management.NotificationListener;

import org.seasar.log.Logger;
import org.seasar.system.JMXUtil;
import org.seasar.system.Lifecycle;
import org.seasar.system.RMINotificationListenerAdaptor;
import org.seasar.util.Reflector;
import org.seasar.util.SeasarContext;
import org.seasar.util.SeasarRuntimeException;

public final class RemoteNotificationListenerContainer implements Lifecycle {

	private static final Logger _logger = Logger.getLogger(RemoteNotificationListenerContainer.class);
	private String _className;
	private String _targetName;
	private String _seasarContextName = null;
	private Properties _properties = new Properties();
	private NotificationListener _notificationListener;
	private RMINotificationListenerAdaptor _rmiNotificationListenerAdaptor;
	
	public RemoteNotificationListenerContainer(String className, String targetName,
			String seasarContextName) {
				
		if (className == null) {
			throw new SeasarRuntimeException("ESSR0007", new Object[]{"className"});
		}
		_className = className;
		if (targetName == null) {
			throw new SeasarRuntimeException("ESSR0007", new Object[]{"targetName"});
		}
		_targetName = targetName;
		if (seasarContextName == null) {
			throw new SeasarRuntimeException("ESSR0007", new Object[]{"seasarContextName"});
		}
		_seasarContextName = seasarContextName;
	}
	
	public void setProperty(String name, String value) {
		_properties.setProperty(name, value);
	}
	
	public NotificationListener getNotificationListener() {
		return _notificationListener;
	}
	
	public RMINotificationListenerAdaptor getRMINotificationListenerAdaptor() {
		return _rmiNotificationListenerAdaptor;
	}
	
	public void start() {
		try {
			_notificationListener = (NotificationListener) Reflector.newInstance(_className);
			Reflector.setProperties(_notificationListener, _properties);
			if (_notificationListener instanceof Lifecycle) {
				((Lifecycle) _notificationListener).start();
			}
			_rmiNotificationListenerAdaptor = new RMINotificationListenerAdaptor(
				JMXUtil.getMBeanName(_targetName), _notificationListener, SeasarContext.getInstance(_seasarContextName));
			_rmiNotificationListenerAdaptor.addNotificationListener();
		} catch (Throwable t) {
			_logger.log(t);
		}
	}
	
	public void stop() {
		try {
			if (_rmiNotificationListenerAdaptor != null) {
				_rmiNotificationListenerAdaptor.removeNotificationListener();
			}
		} catch (Throwable t) {
			_logger.log(t);
		} finally {
			_rmiNotificationListenerAdaptor = null;
			_notificationListener = null;
		}
	}
}
