package org.seasar.nazuna;

import org.seasar.util.Assertion;

public final class StringExp implements Expression {

    private final String _value;

    public StringExp(final String value) {
    	Assertion.assertNotNull("value", value);

        _value = value;
    }

    public Object evaluateValue(final RuleContext ruleContext) {
        return _value;
    }
}
