package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.Conversion;
import org.seasar.util.SeasarException;

public final class ToBigDecimalExp implements Expression {

    private final Expression _arg1Exp;
    private final String _pattern;

    public ToBigDecimalExp(final Expression arg1Exp, final String pattern) {
		Assertion.assertNotNull("arg1Exp", arg1Exp);
        
        _arg1Exp = arg1Exp;
        _pattern = pattern;
    }

    public Object evaluateValue(final RuleContext ruleContext)
    		throws SeasarException {
    			
        Object o = _arg1Exp.evaluateValue(ruleContext);
        return Conversion.toBigDecimal(o, _pattern);
    }
}
