package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public class Var {

	public static final Var OUT = new Out();
	protected VarType _varType;
	protected Object _value;
	
	public Var(VarType varType) throws SeasarException {
		Assertion.assertNotNull("varType", varType);
		
		_varType = varType;
		_value = varType.getInitValue();
	}

	protected Var() {
	}
		
	public VarType getVarType() {
		return _varType;
	}
	
	public String getName() {
		return _varType.getName();
	}
	
	public Object getValue() {
		return _value;
	}
	
	public void setValue(Object value) throws SeasarException {
		_varType.validate(value);
		_value = value;
	}
	
	private static class Out extends Var {
		
		Out() {
			_varType = VarType.OUT_TYPE;
			_value = VarType.OUT_TYPE.getInitValue();
		}
		
		public void setValue(Object value) throws SeasarException {
			throw new SeasarException("ESSR0010", new Object[]{"setValue"});
		}
	}
}
