package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public class VarType {

	public static final OutType OUT_TYPE = new OutType();
	private String _name;
	private Class _varClass;
	private Expression _initExp;

	public VarType(String name, Class varClass) {
		Assertion.assertNotNull("name", name);
		Assertion.assertTrue(NazunaUtil.isVarArgStartChar(name.charAt(0)), "ESSR0037", null);
		Assertion.assertNotNull("varClass", varClass);
		
		_name = name;
		_varClass = varClass;			
	}
	
	public final String getName() {
		return _name;
	}
	
	public final Class getVarClass() {
		return _varClass;
	}
	
	public Object getInitValue() throws SeasarException {
		if (_initExp == null) {
			return null;
		}			
		Object value = _initExp.evaluateValue(null);
		validate(value);
		return value;
	}
	
	public final void setInitExp(Expression initExp) throws SeasarException {
		Assertion.assertNotNull("initExp", initExp);
		_initExp = initExp;
	}
	
	public final void validate(Object value) throws SeasarException {
		if (value != null && !_varClass.isInstance(value)) {
			throw new SeasarException("ESSR0002",
				new Object[]{_name, _varClass.getName(), value.getClass().getName()});
		}
	}
	
	public static class OutType extends VarType {
		
		OutType() {
			super("out", System.out.getClass());
		}
		
		public Object getInitValue() {
			return System.out;
		}
	}
}
