package org.seasar.util;

public class Sorter {

    public Sorter() {
    }

    public final void sort(final Object dest[]) {
        sort(dest, 0, dest.length);
    }

    public final void sort(final Object dest[], final int low, final int high) {
        Object[] src = (Object[])dest.clone();
        mergeSort(src, dest, low, high);
    }

    protected int doCompare(final Object o1, final Object o2) {
        return ((Comparable)o1).compareTo(o2);
    }

    private void mergeSort(final Object src[], final Object dest[],
            final int low, final int high) {

        int length = high - low;
        if (length < 7) {
            bubbleSort(dest, low, high);
            return;
        }
        int mid = (low + high) / 2;
        mergeSort(dest, src, low, mid);
        mergeSort(dest, src, mid, high);
        if (doCompare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        for (int i = low, p = low, q = mid; i < high; i++) {
            if (q >= high || p < mid && doCompare(src[p], src[q]) <= 0) {
                dest[i] = src[p++];
            } else {
                dest[i] = src[q++];
            }
        }
    }

    private void bubbleSort(final Object dest[], final int low, final int high) {
        for (int i = low; i < high; i++) {
            for (int j = i; j > low && doCompare(dest[j - 1], dest[j]) > 0; j--) {
                swap(dest, j, j - 1);
            }
        }
    }

    private static void swap(final Object x[], final int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
    }
}