package org.seasar.eclipse;

import java.io.File;
import java.io.FilenameFilter;

public final class JarZipFilter implements FilenameFilter {

	private static final File[] EMPTY_FILES = new File[0];
	private static JarZipFilter _instance = new JarZipFilter();
	
	private JarZipFilter() {
	}
	
	public static final File[] listFiles(File dir) {
		File[] files = dir.listFiles(_instance);
		if (files == null) {
			files = EMPTY_FILES;
		}
		return files;
	}

	public boolean accept(File dir, String name) {
		name = name.toLowerCase();
        return name.endsWith("jar") || name.endsWith("zip");
	}
}
