package org.seasar.boot;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public final class Bootstrap implements FilenameFilter {
	
	private static File _home;
	private String _className;
	private String[] _args;
	private List _urlList = new ArrayList();
	private StringBuffer _classpathBuf = new StringBuffer(100);
	private ClassLoader _classLoader;
	
	static {
		setupHome();
	}
	
	public Bootstrap(String className, String[] args) throws Exception {
		_className = className;
		_args = args;
		setupClasspath();
	}

    public static void main(String args[]) {
        try {
            String className = args[0];
            String[] args2 = new String[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
            	args2[i - 1] = args[i];
            }
            Bootstrap bootstrap = new Bootstrap(className, args2);
            bootstrap.start();
            System.exit(0);
        } catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

	public boolean accept(File dir, String name) {
		String ext = "";
		int extPos = name.lastIndexOf(".");
		if (extPos >= 0) {
			ext = name.substring(extPos + 1);
		}
		return "jar".equalsIgnoreCase(ext) || "zip".equalsIgnoreCase(ext);
	}

	public void start() throws Exception {
		Class clazz = _classLoader.loadClass(_className);
		Method main = clazz.getMethod("main", new Class[]{(new String[0]).getClass()});
		main.invoke(null, new Object[]{_args});
	}
	
    private static void setupHome() {
		URL url = Thread.currentThread().getContextClassLoader().getResource("org/seasar/boot/Bootstrap.class");
		String s = url.toExternalForm();
		int pos = s.lastIndexOf('!');
		String s2 = s.substring(9, pos);
		File f = new File(s2);
		_home = f.getParentFile().getParentFile();
    }
    
    private void setupClasspath() throws Exception {
    	setupClasses();
    	setupLib();
		URL[] urls = (URL[])_urlList.toArray(new URL[_urlList.size()]);
		ClassLoader parent = ClassLoader.getSystemClassLoader();
		_classLoader = new URLClassLoader(urls, parent);
		Thread.currentThread().setContextClassLoader(_classLoader);
		System.setProperty("java.class.path", _classpathBuf.toString());
		System.setProperty("seasar.home", _home.getCanonicalPath());
    }
    
	private void setupClasses() throws Exception {
		File classesDir = new File(_home, "classes");
		if (classesDir.exists()) {
			_urlList.add(classesDir.toURL());
			_classpathBuf.append(classesDir.getPath());
			_classpathBuf.append(File.pathSeparatorChar);
		}
	}
	
	private void setupLib() throws Exception {
		File libDir = new File(_home, "lib");
		File[] files = libDir.listFiles(this);
		if (files == null) {
			return;
		}
		for (int i = 0; i < files.length; ++i) {
			_urlList.add(files[i].toURL());
			_classpathBuf.append(files[i].getPath());
			_classpathBuf.append(File.pathSeparatorChar);
		}
	}
}
