package org.seasar.nazuna;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.Map;

import org.seasar.util.Assertion;
import org.seasar.util.Reflector;
import org.seasar.util.SeasarException;

public final class PropertyType {

	private String _name;
	private String _columnName;
	private ValueType _valueType;
	private Method _setterMethod;
	
	
	public PropertyType(String name, String columnName, Class resultClass,
			String typeName) {
				
		Assertion.assertNotNull("name", name);
    	Assertion.assertNotNull("columnName", columnName);
    	Assertion.assertNotNull("resultClass", resultClass);

		_name = name;
		_columnName = columnName;
		if (!Map.class.isAssignableFrom(resultClass)) {
			_setterMethod = Reflector.getWriteMethod(resultClass, name);
			_valueType = ValueType.getType(_setterMethod.getParameterTypes()[0]);
		} else {
			if (typeName != null) {
				_valueType = ValueType.getType(typeName);
			} else {
				_valueType = ValueType.STRING;
			}
		}
	}
	
	public String getName() {
		return _name;
	}
	
	public String getColumnName() {
		return _columnName;
	}
	
	public ValueType getValueType() {
		return _valueType;
	}
	
	public void fetchForMap(ResultSet rs, Map map) throws SeasarException {
		Object value = _valueType.getValue(rs, _columnName);
		map.put(_name, value);
	}
	
	public void fetchForBean(ResultSet rs, Object bean) throws SeasarException {
		Object value = _valueType.getValue(rs, _columnName);
		Reflector.invokeNoException(_setterMethod, bean, new Object[]{value});
	}
}
