package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.ExecuteExp;
import org.seasar.nazuna.Expression;
import org.seasar.nazuna.Flowlet;
import org.seasar.nazuna.FlowletBuilder;
import org.seasar.nazuna.StringExp;
import org.seasar.util.EMap;

public class ExecuteExpTest extends TestCase {

    public ExecuteExpTest(String name) {
        super(name);
    }

    public void testExecuteValue() throws Exception {
    	String xmlFileName = "/test/org/seasar/nazuna/Return.xml";
    	Expression exp = new ExecuteExp(new StringExp(xmlFileName), new EMap());
        assertEquals("1", "Hello", exp.evaluateValue(null));
    }
    
    public void testExecuteValue2() throws Exception {
    	String xmlFileName = "/test/org/seasar/nazuna/Hello2.xml";
    	EMap parameterExps = new EMap();
    	parameterExps.put("name", new StringExp("Nazuna"));
    	Expression exp = new ExecuteExp(new StringExp(xmlFileName), parameterExps);
        assertEquals("1", null, exp.evaluateValue(null));
    }
    
    public void testExecuteValue3() throws Exception {
    	String xmlFileName = "/test/org/seasar/nazuna/Execute.xml";
    	EMap parameterExps = new EMap();
    	parameterExps.put("name", new StringExp("Nazuna"));
    	Expression exp = new ExecuteExp(new StringExp(xmlFileName), parameterExps);
        assertEquals("1", "Hello Nazuna", exp.evaluateValue(null));
    }
    
    public void testExecute() throws Exception {
    	String xmlFileName = "/test/org/seasar/nazuna/Execute.xml";
    	Flowlet flowlet = FlowletBuilder.parse(xmlFileName);
        assertEquals("1", "Hello Nazuna", flowlet.execute());
    }
        
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(ExecuteExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{ExecuteExpTest.class.getName()});
    }
}