package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.DoubleExp;
import org.seasar.nazuna.IntegerExp;
import org.seasar.nazuna.MultDivModExp;
import org.seasar.nazuna.NullExp;
import org.seasar.nazuna.RuleTokenizer;
import org.seasar.nazuna.StringExp;
import org.seasar.nazuna.ToLongExp;

public class MultDivModExpTest extends TestCase {

    public MultDivModExpTest(String name) {
        super(name);
    }

    public void testMultiply() throws Exception {
    	IntegerExp i1Con = new IntegerExp(new Integer(2));
    	IntegerExp i2Con = new IntegerExp(new Integer(3));
    	MultDivModExp exp = new MultDivModExp(i1Con, i2Con, RuleTokenizer.MULTIPLY);
        assertEquals("1", new Integer(6), exp.evaluateValue(null));
    }
    
    public void testMultiply2() throws Exception {
    	ToLongExp toLong1Exp = new ToLongExp(new StringExp("2"), null);
    	ToLongExp toLong2Exp = new ToLongExp(new StringExp("3"), null);
    	MultDivModExp exp = new MultDivModExp(toLong1Exp, toLong2Exp, RuleTokenizer.MULTIPLY);
        assertEquals("1", new Long(6), exp.evaluateValue(null));
    }
    
    public void testMultiply3() throws Exception {
    	DoubleExp double1Exp = new DoubleExp(new Double(2));
    	DoubleExp double2Exp = new DoubleExp(new Double(3));
    	MultDivModExp exp = new MultDivModExp(double1Exp, double2Exp, RuleTokenizer.MULTIPLY);
        assertEquals("1", new Double(6), exp.evaluateValue(null));
    }
    
    public void testMultiply4() throws Exception {
    	IntegerExp i1Con = new IntegerExp(new Integer(1));
    	MultDivModExp exp = new MultDivModExp(i1Con, new NullExp(), RuleTokenizer.MULTIPLY);
        assertEquals("1", null, exp.evaluateValue(null));
    }
    
    public void testDivide() throws Exception {
    	IntegerExp i1Con = new IntegerExp(new Integer(5));
    	IntegerExp i2Con = new IntegerExp(new Integer(2));
    	MultDivModExp exp = new MultDivModExp(i1Con, i2Con, RuleTokenizer.DIVIDE);
        assertEquals("1", new Integer(2), exp.evaluateValue(null));
    }
    
    public void testDivide2() throws Exception {
    	ToLongExp toLong1Exp = new ToLongExp(new StringExp("5"), null);
    	ToLongExp toLong2Exp = new ToLongExp(new StringExp("2"), null);
    	MultDivModExp exp = new MultDivModExp(toLong1Exp, toLong2Exp, RuleTokenizer.DIVIDE);
        assertEquals("1", new Long(2), exp.evaluateValue(null));
    }
    
    public void testDivide3() throws Exception {
    	DoubleExp double1Exp = new DoubleExp(new Double(5));
    	DoubleExp double2Exp = new DoubleExp(new Double(2));
    	MultDivModExp exp = new MultDivModExp(double1Exp, double2Exp, RuleTokenizer.DIVIDE);
        assertEquals("1", new Double(2.5), exp.evaluateValue(null));
    }
    
    public void testMod() throws Exception {
    	IntegerExp i1Con = new IntegerExp(new Integer(5));
    	IntegerExp i2Con = new IntegerExp(new Integer(2));
    	MultDivModExp exp = new MultDivModExp(i1Con, i2Con, RuleTokenizer.MOD);
        assertEquals("1", new Integer(1), exp.evaluateValue(null));
    }
    
    public void testMod2() throws Exception {
    	ToLongExp toLong1Exp = new ToLongExp(new StringExp("5"), null);
    	ToLongExp toLong2Exp = new ToLongExp(new StringExp("2"), null);
    	MultDivModExp exp = new MultDivModExp(toLong1Exp, toLong2Exp, RuleTokenizer.MOD);
        assertEquals("1", new Long(1), exp.evaluateValue(null));
    }
    
    public void testMod3() throws Exception {
    	DoubleExp double1Exp = new DoubleExp(new Double(5));
    	DoubleExp double2Exp = new DoubleExp(new Double(2));
    	MultDivModExp exp = new MultDivModExp(double1Exp, double2Exp, RuleTokenizer.MOD);
        assertEquals("1", new Double(1), exp.evaluateValue(null));
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(MultDivModExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{MultDivModExpTest.class.getName()});
    }
}