package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.Expression;
import org.seasar.nazuna.NullExp;
import org.seasar.nazuna.NvlExp;
import org.seasar.nazuna.StringExp;

public class NvlExpTest extends TestCase {

    public NvlExpTest(String name) {
        super(name);
    }

    public void testEvaluateValue() throws Exception {
    	Expression arg1Exp = new NullExp();
    	Expression arg2Exp = new StringExp("aaa");
    	Expression exp = new NvlExp(arg1Exp, arg2Exp);
        assertEquals("1", "aaa", exp.evaluateValue(null));
    }
    
    public void testEvaluateValue2() throws Exception {
    	Expression arg1Exp = new StringExp("aaa");
    	Expression arg2Exp = new NullExp();
    	Expression exp = new NvlExp(arg1Exp, arg2Exp);
        assertEquals("1", "aaa", exp.evaluateValue(null));
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(NvlExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{NvlExpTest.class.getName()});
    }
}