package test.org.seasar.util;

import junit.framework.*;
import org.seasar.util.*;

public class StringUtilTest extends TestCase {

    public StringUtilTest(String name) {
        super(name);
    }

    public void testGetLastToken() throws Exception {
        assertEquals("1", "ccc", StringUtil.getLastToken("aaa.bbb.ccc", '.'));
        assertEquals("2", "ccc", StringUtil.getLastToken("ccc", '.'));
    }
    
    public void testSplit() throws Exception {
        String[] array = StringUtil.split("aaa\nbbb", "\n");
        assertEquals("1", 2, array.length);
        assertEquals("2", "aaa", array[0]);
        assertEquals("3", "bbb", array[1]);
    }

    
    public void testLtrim() throws Exception {
        assertEquals("1", "trim", StringUtil.ltrim("zzzytrim", "xyz"));
        assertEquals("2", "", StringUtil.ltrim("xyz", "xyz"));
    }
    
    public void testRtrim() throws Exception {
        assertEquals("1", "trim", StringUtil.rtrim("trimxxxx", "x"));
        assertEquals("2", "", StringUtil.rtrim("xyz", "xyz"));
        assertEquals("1", "trimxxxx", StringUtil.rtrim("trimxxxx", "y"));
    }
    
    public void testBtrim() throws Exception {
        assertEquals("1", "trim", StringUtil.btrim("xyxtrimyyx", "xy"));
        assertEquals("2", "", StringUtil.btrim("xyz", "xyz"));
        assertEquals("1", "trimxxxx", StringUtil.btrim("trimxxxx", "y"));
    }
    
    public void testLpad() throws Exception {
        assertEquals("1", "abc", StringUtil.lpad("abcde", 3));
    }
    
    public void testLpad2() throws Exception {
        assertEquals("1", "abcde", StringUtil.lpad("abcde", 5));
    }
    
    public void testLpad3() throws Exception {
        assertEquals("1", " abcde", StringUtil.lpad("abcde", 6));
    }
    
    public void testLpad4() throws Exception {
        assertEquals("1", "xyxyabcde", StringUtil.lpad("abcde", 9, "xy"));
    }
    
    public void testLpad5() throws Exception {
        assertEquals("1", "xyxyxabcde", StringUtil.lpad("abcde", 10, "xy"));
    }
    
    public void testRpad() throws Exception {
        assertEquals("1", "abc", StringUtil.rpad("abcde", 3));
    }
    
    public void testRpad2() throws Exception {
        assertEquals("1", "abcde", StringUtil.rpad("abcde", 5));
    }
    
    public void testRpad3() throws Exception {
        assertEquals("1", "abcde ", StringUtil.rpad("abcde", 6));
    }
    
    public void testRpad4() throws Exception {
        assertEquals("1", "abcdexyxy", StringUtil.rpad("abcde", 9, "xy"));
    }
    
    public void testRpad5() throws Exception {
        assertEquals("1", "abcdexyxyx", StringUtil.rpad("abcde", 10, "xy"));
    }
    
    public void testRcut() throws Exception {
        assertEquals("1", "xxxx", StringUtil.rcut("xxxxabc", "abc"));
    }
    
    public void testTranslate() throws Exception {
        assertEquals("1", "a234e", StringUtil.translate("12345", "15", "ae"));
        assertEquals("2", "a234", StringUtil.translate("12345", "15", "a"));
    }
    
    public void testReplace() throws Exception {
        assertEquals("1", "1bc45", StringUtil.replace("12345", "23", "bc"));
        assertEquals("2", "1234ef", StringUtil.replace("12345", "5", "ef"));
        assertEquals("3", "ab2345", StringUtil.replace("12345", "1", "ab"));
        assertEquals("4", "a234a", StringUtil.replace("12341", "1", "a"));
        assertEquals("5", "ab234abab234ab", StringUtil.replace("1234112341", "1", "ab"));
        assertEquals("6", "a\\nb", StringUtil.replace("a\nb", "\n", "\\n"));
    }
    
    public void testRepeat() throws Exception {
        assertEquals("1", "PgPgPgPg", StringUtil.repeat("Pg", 4));
        assertEquals("2", "", StringUtil.repeat("Pg", 0));
    }
    
    public void testAscii() throws Exception {
        assertEquals("1", 120, StringUtil.ascii("x"));
    }
    
    public void testChr() throws Exception {
        assertEquals("1", "A", StringUtil.chr(65));
    }
    
    public void testStrpos() throws Exception {
        assertEquals("1", 2, StringUtil.strpos("abc", "b"));
        assertEquals("2", 0, StringUtil.strpos("abc", "d"));
    }
    
    public void testSubstr() throws Exception {
        assertEquals("1", "bcd", StringUtil.substr("abcdefg", 2, 3));
        assertEquals("2", "bcdefg", StringUtil.substr("abcdefg", 2));
        assertEquals("3", "bcdefg", StringUtil.substr("abcdefg", 2, 100));
        assertEquals("4", null, StringUtil.substr("abcdefg", 2, 0));
        assertEquals("5", "abc", StringUtil.substr("abcdefg", 0, 3));
        assertEquals("6", "abc", StringUtil.substr("abcdefg", 1, 3));
        assertEquals("7", null, StringUtil.substr("abcdefg", 8, 3));
    }
 
 	public void testSubstrb() throws Exception {
        assertEquals("1", "", StringUtil.substrb("", 5));
        assertEquals("2", "", StringUtil.substrb("", 4));
        assertEquals("3", "", StringUtil.substrb("", 6));
        assertEquals("4", "", StringUtil.substrb("", 7));
        assertEquals("5", "", StringUtil.substrb("", 1));
        assertEquals("6", "", StringUtil.substrb("", 0));
    }
    
    public void testIndexOf() throws Exception {
    	char[] src = "acbcde".toCharArray();
    	char[] target = "cd".toCharArray();
        assertEquals("1", 3, StringUtil.indexOf(src, 0, src.length, target, 0, target.length, 0));
    }
    
    protected void setUp() throws Exception {
    }


    protected void tearDown() throws Exception {
    }


    public static Test suite() {
        return new TestSuite(StringUtilTest.class);
    }



    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{StringUtilTest.class.getName()});
    }
}
