package test.org.seasar.util;

import junit.framework.*;
import org.seasar.util.*;

public class ThrowableUtilTest extends TestCase {

    public ThrowableUtilTest(String name) {
        super(name);
    }

    public void testGetCause() throws Exception {
        Throwable cause = new NullPointerException("");
        Throwable t = new SeasarException("ESSR0017", new Object[]{cause}, cause);
        Throwable t2 = new SeasarException("ISSR0001");
        assertEquals("1", cause, ThrowableUtil.getCause(t));
        assertEquals("2", cause, ThrowableUtil.getCause(cause));
        assertEquals("3", t2, ThrowableUtil.getCause(t2));
    }
    
    public void testGetStackTraceString() throws Exception {
        Throwable t = new NullPointerException("hoge");
        String s = ThrowableUtil.getStackTraceString(t);
        System.out.println(s);
        assertNotNull("1", s);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite() {
        return new TestSuite(ThrowableUtilTest.class);
    }



    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{ThrowableUtilTest.class.getName()});
    }
}