/*
class seasar.unit.TestCase extends seasar.unit.Assert

public:
TestResult run()

protected:
void setUp()
void tearDown()
void runTest(seasar.unit.TestResult testResult)
*/

if (seasar.unit.TestCase === undefined) {
	#include "seasar/lang/SObject.as"
	#include "seasar/unit/Assert.as"
	#include "seasar/unit/TestResult.as"
	
	seasar.lang.SObject.defineClass("seasar.unit.TestCase", seasar.unit.Assert, ["traceVisible"],
		function() {
			super();
			this.traceVisible = true;
		});
	var proto = seasar.unit.TestCase.prototype;
	
	proto.setUp = function() {
	}
	
	proto.tearDown = function() {
	}
	
	proto.run = function() {
		var testResult = new seasar.unit.TestResult();
		this.runTest(testResult);
		if (this.traceVisible) {
			trace(testResult);
		}
		return testResult;
	}
	
	proto.runTest = function(testResult) {
		for (var p in this) {
			if (typeof this[p] == "function" && p.substring(0,4).toLowerCase() == "test") {
				this.prepare(testResult, p);
				this.setUp();
				this[p]();
				this.tearDown();
			}
		}
	}
	
	ASSetPropFlags(proto,"setUp,tearDown,run,runTest",1);
	
	delete proto;
}