package org.seasar.system;

import java.rmi.RemoteException;

import javax.management.Notification;
import javax.management.NotificationListener;

import org.seasar.log.Logger;
import org.seasar.util.LongId;
import org.seasar.util.SeasarException;

public final class RMINotificationListenerServerAdaptor
		implements NotificationListener,  RMINotificationListenerServerAdaptorMBean {

	private static LongId _id = new LongId();
	private RMINotificationListener _rmiNotificationListener;
	private String _targetName;
	private String _listenerName;

	public RMINotificationListenerServerAdaptor(String targetName,
			RMINotificationListener rmiNotificationListener) {
	
		_targetName = targetName;			
		_rmiNotificationListener = rmiNotificationListener;
		_listenerName = "RMINotificationListenerServerAdaptor:id=" + _id.next();
	}

	public String getListenerName() {
		return _listenerName;
	}

	public void addNotificationListener() throws SeasarException {
		JMXService.registerMBean(this, _listenerName);
		JMXService.addNotificationListener(_targetName, _listenerName);
	}
	
	public void removeNotificationListener() throws SeasarException {
		JMXService.removeNotificationListener(_targetName, _listenerName);
		JMXService.unregisterMBean(_listenerName);
	}
			
	public void handleNotification(Notification notification, Object handback) {
		try {
			_rmiNotificationListener.handleRMINotification(notification, handback);
		} catch (RemoteException ex) {
			try {
				removeNotificationListener();
			} catch (SeasarException se) {
				Logger.getLogger(getClass()).log(se);
			}
			Logger.getLogger(getClass()).log(ex);
		}
	}
}
