package org.seasar.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.NoSuchElementException;

public class ELinkedList implements Cloneable, Externalizable {

    static final long serialVersionUID = -6031901980461979602L;
    private transient Entry _header = new Entry(null, null, null);
    private transient int _size = 0;

    public ELinkedList() {
        _header._next = _header._previous = _header;
    }

    public Entry getFirstEntry() {
        if (isEmpty()) {
            return null;
        }
        return _header._next;
    }

    public Object getFirst() {
        if (isEmpty()) {
            throw new NoSuchElementException();
        }
        return getFirstEntry()._element;
    }

    public Entry getLastEntry()  {
        if (isEmpty()) {
            return null;
        }
        return _header._previous;
    }

    public Object getLast()  {
        if (isEmpty()) {
            throw new NoSuchElementException();
        }
        return getLastEntry()._element;
    }

    public Object removeFirst() {
        if (isEmpty()) {
            throw new NoSuchElementException();
        }
        Object first = _header._next._element;
        _header._next.remove();
        return first;
    }

    public Object removeLast() {
        if (isEmpty()) {
            throw new NoSuchElementException();
        }
        Object last = _header._previous._element;
        _header._previous.remove();
        return last;
    }

    public void addFirst(final Object o) {
        _header._next.addBefore(o);
    }

    public void addLast(final Object o) {
        _header.addBefore(o);
    }

    public void add(final int index, final Object element) {
        getEntry(index).addBefore(element);
    }

    public int size() {
        return _size;
    }

    public boolean isEmpty() {
        return _size == 0;
    }

    public boolean contains(final Object o) {
        return indexOf(o) != -1;
    }

    public boolean remove(final Object o) {
        if (o == null) {
            for (Entry e = _header._next; e != _header; e = e._next) {
                if (e._element == null) {
                   e.remove();
                    return true;
                }
            }
        } else {
            for (Entry e = _header._next; e != _header; e = e._next) {
                if (o.equals(e._element)) {
                    e.remove();
                    return true;
                }
            }
        }
        return false;
    }

    public Object remove(final int index) {
        Entry e = getEntry(index);
        e.remove();
        return e._element;
    }

    public void clear() {
        _header._next = _header._previous = _header;
        _size = 0;
    }

    public Entry getEntry(final int index) {
        if (index < 0 || index >= _size) {
            throw new IndexOutOfBoundsException(
                "Index: " + index + ", Size: " + _size);
        }
        Entry e = _header;
        if (index < _size / 2) {
            for (int i = 0; i <= index; i++) {
                e = e._next;
            }
        } else {
            for (int i = _size; i > index; i--) {
                e = e._previous;
            }
        }
        return e;
    }

    public Object get(final int index) {
        return getEntry(index)._element;
    }

    public Object set(final int index, final Object element) {
        Entry e = getEntry(index);
        Object oldVal = e._element;
        e._element = element;
        return oldVal;
    }

    public int indexOf(final Object o) {
        int index = 0;
        if (o == null) {
            for (Entry e = _header._next; e != _header; e = e._next) {
                if (e._element == null) {
                    return index;
                }
                index++;
            }
        } else {
            for (Entry e = _header._next; e != _header; e = e._next) {
                if (o.equals(e._element)) {
                    return index;
                }
                index++;
            }
        }
        return -1;
    }

    public void writeExternal(final ObjectOutput s) throws IOException {
        s.writeInt(_size);
        for (Entry e = _header._next; e != _header; e = e._next) {
            s.writeObject(e._element);
        }
    }

    public void readExternal(ObjectInput s)
            throws IOException, ClassNotFoundException {

        int size = s.readInt();
        _header = new Entry(null, null, null);
        _header._next = _header._previous = _header;
        for (int i = 0; i < _size; i++) {
            addLast(s.readObject());
        }
    }

    public Object clone() {
        ELinkedList copy = new ELinkedList();
        for (Entry e = _header._next; e != _header; e = e._next) {
            copy.addLast(e._element);
        }
        return copy;
    }

    public Object[] toArray() {
        Object[] result = new Object[_size];
        int i = 0;
        for (Entry e = _header._next; e != _header; e = e._next) {
            result[i++] = e._element;
        }
        return result;
    }

    public final class Entry {

        private Object _element;
        private Entry _next;
        private Entry _previous;

        Entry(final Object element, final Entry next, final Entry previous) {
            _element = element;
            _next = next;
            _previous = previous;
        }

        public Object getElement() {
            return _element;
        }

        public Entry getNext() {
            if (_next != ELinkedList.this._header) {
                return _next;
            } else {
                return null;
            }
        }

        public Entry getPrevious() {
            if (_previous != ELinkedList.this._header) {
                return _previous;
            } else {
                return null;
            }
        }

        public void remove() {
            _previous._next = _next;
            _next._previous = _previous;
            ELinkedList.this._size--;
        }

        public Entry addBefore(final Object o) {
            Entry newEntry = new Entry(o, this, _previous);
            _previous._next = newEntry;
            _previous = newEntry;
            ELinkedList.this._size++;
            return newEntry;
        }
    }
}