package test.org.seasar.naming;

import java.util.Hashtable;

import javax.naming.Context;

import org.seasar.naming.NamingService;
import org.seasar.system.JMXService;
import org.seasar.system.RMIAdaptorService;

import test.org.seasar.system.RMIAdaptorTestCase;

public class NamingTestCase extends RMIAdaptorTestCase {
	
	protected JMXService _jmxService;
	protected RMIAdaptorService _rmiService;
	protected NamingService _namingService;
	protected Hashtable _env;
	
    public NamingTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
    	super.setUp();
    	_namingService = new NamingService();
    	_namingService.start();
    	_env = new Hashtable();
        _env.put(Context.INITIAL_CONTEXT_FACTORY, "org.seasar.naming.NamingContextFactory");
        _env.put(Context.URL_PKG_PREFIXES, "org.seasar.naming");
    }

    protected void tearDown() throws Exception {
    	_namingService.stop();
    	_namingService = null;
    	super.tearDown();
    }
}
