package test.org.seasar.nazuna;

import java.util.List;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.nazuna.ExecuteQueryExp;
import org.seasar.nazuna.Expression;
import org.seasar.nazuna.RuleParser;
import org.seasar.nazuna.StringExp;
import org.seasar.util.EMap;

import test.org.seasar.sql.ConnectionPoolTestCase;

public class ExecuteQueryExpTest extends ConnectionPoolTestCase {

    public ExecuteQueryExpTest(String name) {
        super(name);
    }

    public void testDoExecute() throws Exception {
    	String path = "/test/org/seasar/nazuna/select.xml";
    	Expression exp = new ExecuteQueryExp(new StringExp(path), new EMap());
    	List ret = (List) exp.evaluateValue(null);
        assertEquals("1", 14, ret.size());
    }
    
    public void testParse() throws Exception {
    	String s = "executeQuery('/test/org/seasar/nazuna/selectWhere.xml', empno := 7788)";
    	Expression exp = new RuleParser(s).parseExpression();
    	List ret = (List) exp.evaluateValue(null);
        assertEquals("1", 1, ret.size());
    }
        
    protected void setUp() throws Exception {
    	super.setUp();
    }

    protected void tearDown() throws Exception {
    	super.tearDown();
    }

    public static Test suite ( ) {
        return new TestSuite(ExecuteQueryExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{ExecuteQueryExpTest.class.getName()});
    }
}