package test.org.seasar.nazuna.amf;

import java.util.*;
import org.seasar.nazuna.amf.*;

import junit.framework.TestCase;

public class AMFBodyTest extends TestCase {

	private AMFBody _body = new AMFBody("abc.def.Hoge.foo", "aaa", "111");
	
	public AMFBodyTest(String arg0) {
		super(arg0);
	}
	
	public void testGetServiceName() {
		assertEquals("1", "abc.def.Hoge", _body.getServiceName());
	}
	
	public void testGetServiceMethodName() {
		assertEquals("1", "foo", _body.getServiceMethodName());
	}
	
	public void testInvokeRulet() throws Exception {
		String target = "test.org.seasar.nazuna.amf.AddRulet.executeRulet";
		List value = new ArrayList();
		value.add("1");
		value.add("2");
		AMFBody body = new AMFBody(target, "response", value);
		assertEquals("1", new Integer(3), body.invoke(null));
	}
	
	public void testInvokeFlowlet() throws Exception {
		String target = "test.org.seasar.nazuna.amf.AddFlowlet.execute";
		List value = new ArrayList();
		value.add("1");
		value.add("2");
		AMFBody body = new AMFBody(target, "response", value);
		assertEquals("1", new Integer(3), body.invoke(null));
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(AMFBodyTest.class);
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

}
