package test.org.seasar.sql;

import java.sql.Connection;
import java.util.Properties;

import javax.sql.XAConnection;
import javax.sql.XADataSource;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.sql.ConnectionPoolMetaData;
import org.seasar.sql.XAConnectionImpl;
import org.seasar.util.Serializer;

public class ConnectionPoolMetaDataTest extends TestCase {

    private ConnectionPoolMetaData _cpmd;

    public ConnectionPoolMetaDataTest(String name) {
        super(name);
    }

    public void testGetXAConnection() throws Exception {
        XAConnection xaCon = _cpmd.getXAConnection();
        try {
            assertNotNull("1", xaCon);
            assertEquals("2", XAConnectionImpl.class,
                    xaCon.getClass());
        } finally {
            xaCon.close();
        }
    }

    public void testGetXADataSource() throws Exception {
        XADataSource ds = _cpmd.getXADataSource();
        assertNotNull("1", ds);
        XAConnection xaCon = ds.getXAConnection();
        try {
            Connection con = xaCon.getConnection();
            con.close();
            assertTrue("2", con.isClosed());
            con = xaCon.getConnection();
            assertTrue("3", !con.isClosed());
        } finally {
            xaCon.close();
        }
    }

    public void testSerialize() throws Exception {
        Serializer.serialize(_cpmd);
    }

    protected void setUp() throws Exception {
        Properties p = new Properties();
        p.setProperty("URL", "jdbc:oracle:thin:@d1606:1521:ark");
        p.setProperty("user", "ark");
        p.setProperty("password", "ark");
        p.setProperty("portNumber", "1521");
        _cpmd = new ConnectionPoolMetaData("oracle", "jdbc/oracle",
                "oracle.jdbc.xa.client.OracleXADataSource", 600, 1, p);
    }

    protected void tearDown() throws Exception { }

    public static Test suite() {
        return new TestSuite(ConnectionPoolMetaDataTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{ConnectionPoolMetaDataTest.class.getName()});
    }
}
