package test.org.seasar.transaction;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.transaction.TransactionImpl;
import org.seasar.transaction.XidImpl;

public class TransactionPerformanceTest extends TestCase {

    public TransactionPerformanceTest(String name) {
        super(name);
    }

    public void testBeginCommit() throws Exception {
    	long start = System.currentTimeMillis();
        TransactionImpl tx = new TransactionImpl(new XidImpl());
        System.out.println("new:" + (System.currentTimeMillis() - start));
        
        start = System.currentTimeMillis();
        tx.begin();
        System.out.println("begin:" + (System.currentTimeMillis() - start));
        
        start = System.currentTimeMillis();
        tx.commit();
        System.out.println("commit:" + (System.currentTimeMillis() - start));
        
        start = System.currentTimeMillis();
        tx.init(new XidImpl());
        System.out.println("init:" + (System.currentTimeMillis() - start));
        
        start = System.currentTimeMillis();
        tx = new TransactionImpl(new XidImpl());
        System.out.println("new2:" + (System.currentTimeMillis() - start));
        
        start = System.currentTimeMillis();
        tx.begin();
        System.out.println("begin2:" + (System.currentTimeMillis() - start));
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(TransactionPerformanceTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{TransactionPerformanceTest.class.getName()});
    }
}