package test.org.seasar.util;

import junit.framework.*;
import org.seasar.util.*;

public class SorterTest extends TestCase {

    public SorterTest(String name) {
        super(name);
    }

    public void testSort() throws Exception {
        Sorter sorter = new Sorter();
        Object[] array = new Object[5];
        array[0] = "d";
        array[1] = "c";
        array[2] = "a";
        array[3] = "e";
        array[4] = "b";
        sorter.sort(array);
        assertEquals("1", "a", array[0]);
        assertEquals("2", "b", array[1]);
        assertEquals("3", "c", array[2]);
        assertEquals("4", "d", array[3]);
        assertEquals("5", "e", array[4]);

        sorter.sort(array);
        assertEquals("6", "a", array[0]);
        assertEquals("7", "b", array[1]);
        assertEquals("8", "c", array[2]);
        assertEquals("9", "d", array[3]);
        assertEquals("10", "e", array[4]);

        Object[] array2 = new Object[10];
        array2[0] = "j";
        array2[1] = "d";
        array2[2] = "g";
        array2[3] = "c";
        array2[4] = "a";
        array2[5] = "f";
        array2[6] = "i";
        array2[7] = "e";
        array2[8] = "b";
        array2[9] = "h";
        sorter.sort(array2);
        assertEquals("11", "a", array2[0]);
        assertEquals("12", "b", array2[1]);
        assertEquals("13", "c", array2[2]);
        assertEquals("14", "d", array2[3]);
        assertEquals("15", "e", array2[4]);
        assertEquals("16", "f", array2[5]);
        assertEquals("17", "g", array2[6]);
        assertEquals("18", "h", array2[7]);
        assertEquals("19", "i", array2[8]);
        assertEquals("20", "j", array2[9]);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite() {
        return new TestSuite(SorterTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{SorterTest.class.getName()});
    }
}