package examples.org.seasar.nazuna;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.seasar.nazuna.Nazuna;
import org.seasar.util.SeasarException;

public class SelectWhereSqletClient {

	private static final String SQLET_NAME =
		"examples.org.seasar.nazuna.SelectWhereSqlet";
		
	public static void main(String[] args) {
		try {
			System.out.println("*** salary is null AND deptno is null");
			List results = Nazuna.executeQuery(SQLET_NAME);
			
			Map parameters = new HashMap();
			parameters.put("salary", new BigDecimal(3000));
			System.out.println();
			System.out.println("*** salary is not null AND deptno is null");
			results = Nazuna.executeQuery(SQLET_NAME, parameters);
			
			parameters = new HashMap();
			parameters.put("deptno", new Integer(30));
			System.out.println();
			System.out.println("*** salary is null AND deptno is not null");
			results = Nazuna.executeQuery(SQLET_NAME, parameters);
			
			parameters = new HashMap();
			parameters.put("salary", new BigDecimal(3000));
			parameters.put("deptno", new Integer(30));
			System.out.println();
			System.out.println("*** salary is not null AND deptno is not null");
			results = Nazuna.executeQuery(SQLET_NAME, parameters);
		} catch (SeasarException ex) {
			ex.printStackTrace();
		}
	}
}
