package org.seasar.transaction;

import javax.naming.NamingException;

import org.seasar.log.Logger;
import org.seasar.naming.NamingContext;
import org.seasar.naming.NamingService;
import org.seasar.system.Lifecycle;
import org.seasar.util.SeasarException;

public class TransactionService implements Lifecycle {

    private static Logger _logger = Logger.getLogger(TransactionService.class);

    public TransactionService() { }

    public void start() throws SeasarException {
        try {
            NamingContext ctx = NamingService.getNamingServer().getNamingContext();
            ctx.bind("java:comp/UserTransaction", UserTransactionImpl.getInstance());
            ctx.bind("javax.transaction.UserTransaction", UserTransactionImpl.getInstance());
            ctx.bind("jta/usertransaction", UserTransactionImpl.getInstance());
        } catch (NamingException ex) {
            throw SeasarException.convertSeasarException(ex);
        }
    }

    public void stop() {
        try {
            NamingContext ctx = NamingService.getNamingServer().getNamingContext();
            ctx.unbind("java:comp/UserTransaction");
            ctx.unbind("javax.transaction.UserTransaction");
            ctx.unbind("jta/usertransaction");
        } catch (NamingException ex) {
            _logger.log("ECHR0017", new Object[]{ex}, ex);
        }
    }
}