package test.org.seasar.system;

import junit.framework.*;
import org.seasar.util.*;
import org.seasar.system.*;

public class ThreadPoolTest extends TestCase {

    ThreadPool _pool;
    Work _work = new Work();

    public ThreadPoolTest(String name) {
        super(name);
    }

    public void testSetMaxSize() throws Exception {
        _pool.setMaxSize(1);
        assertEquals("1", 1, _pool.getMaxSize());
        assertEquals("2", 1, _pool.getMinSize());
        assertEquals("3", 1, _pool.getShrinkSize());
    }

    public void testSetMinSize() throws Exception {
        _pool.setMinSize(51);
        assertEquals("1", 51, _pool.getMaxSize());
        assertEquals("2", 51, _pool.getMinSize());
        assertEquals("3", 51, _pool.getShrinkSize());
    }

    public void testMinSize() throws Exception {
        _pool.setMinSize(3);
        _pool.start();
        assertEquals("1", 3, _pool.getIdleSize());
    }

    public void testSetShrinkSize() throws Exception {
        _pool.setShrinkSize(11);
        assertEquals("1", 11, _pool.getShrinkSize());
        try {
            _pool.setShrinkSize(1);
            fail("2");
        } catch (SeasarRuntimeException ex) {
            System.out.println(ex);
        }
        try {
            _pool.setShrinkSize(100);
            fail("3");
        } catch (SeasarRuntimeException ex) {
            System.out.println(ex);
        }
    }

    public void testRequest() throws Exception {
        _pool.setMaxSize(1);
        _pool.start();
        assertEquals("1", 0, _pool.getActiveSize());
        _pool.request(_work);
        assertEquals("1", 1, _pool.getActiveSize());
        _pool.request(_work);
    }

    public void testRequest2() throws Exception {
        _pool.setMaxSize(1);
        long start = System.currentTimeMillis();
        _pool.start();
        _pool.request(_work);
        _pool.request(_work);
        System.out.println("request2:" + (System.currentTimeMillis() - start));
    }

    public void testShrink() throws Exception {
        int num = 5;
        _pool.setMinSize(0);
        _pool.setShrinkSize(3);
        _pool.setShrinkInterval(1);
        _pool.start();
        for (int i = 0; i < num; i++) {
            _pool.request(_work);
        }
        Thread.sleep(5000);
        assertEquals("1", 3, _pool.getIdleSize());
    }

    public void testSynchronize() throws Exception {
        _pool.start();
        ThreadPool.Worker worker = _pool.requestWorker();
        assertEquals("1", 1, _pool.getActiveSize());
        worker.request(_work);
        worker.synchronize();
        assertEquals("2", true, _work._done);
    }

    public void testSynchronize2() throws Exception {
        _pool.start();
        ThreadPool.Worker worker = _pool.requestWorker();
        worker.request(_work);
        while (!_work._done) {
            Thread.sleep(500);
        }
        worker.synchronize();
    }

    protected void setUp() throws Exception {
        _pool = new ThreadPool();
    }


    protected void tearDown() throws Exception {
        _pool.stop();
    }


    public static Test suite() {
        return new TestSuite(ThreadPoolTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{ThreadPoolTest.class.getName()});
    }

    private class Work implements Runnable {
        boolean _done = false;
        public void run() {
            System.out.println("start");
            try {
                Thread.sleep(2000);
            } catch (Exception ex) {}
            _done = true;
            System.out.println("stop");
        }
    }
}