package test.org.seasar.transaction;

import java.lang.reflect.Method;

import javax.transaction.Status;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.transaction.TransAttribute;
import org.seasar.transaction.TransactionManagerImpl;
import org.seasar.util.Reflector;

public class TransAttributeTest extends TestCase {

	private Method _method = Reflector.getMethod(getClass(), "isTx", null);
	private Method _method2 = Reflector.getMethod(getClass(), "getXid", null);
	
    public TransAttributeTest(String name) {
        super(name);
    }
    
    public boolean isTx() {
    	return TransactionManagerImpl.getInstance().getStatus() == Status.STATUS_ACTIVE;
    }
    
    public String getXid() {
    	return TransactionManagerImpl.getInstance().getTransaction().toString();
    }
    
    public void testGetInstance() throws Exception {
    	assertEquals("1", TransAttribute.SUPPORTS, TransAttribute.getInstance(null));
    	assertEquals("2", TransAttribute.SUPPORTS, TransAttribute.getInstance("Supports"));
    	assertEquals("3", TransAttribute.REQUIRED, TransAttribute.getInstance("Required"));
    	assertEquals("4", TransAttribute.REQUIRES_NEW, TransAttribute.getInstance("RequiresNew"));
    	assertEquals("5", TransAttribute.MANDATORY, TransAttribute.getInstance("Mandatory"));
    }
    
    public void testSupports() throws Exception {
    	assertEquals("1", false, isTx());
    	Boolean ret = (Boolean) TransAttribute.SUPPORTS.invoke(_method, this, null);
    	assertEquals("2", false, isTx());
    	assertEquals("3", false, ret.booleanValue());
    }
    
    public void testRequired() throws Exception {
    	assertEquals("1", false, isTx());
    	Boolean ret = (Boolean) TransAttribute.REQUIRED.invoke(_method, this, null);
    	assertEquals("2", false, isTx());
    	assertEquals("3", true, ret.booleanValue());
    }
    
    public void testRequired2() throws Exception {
    	assertEquals("1", false, isTx());
    	TransactionManagerImpl.getInstance().begin();
    	Boolean ret = null;
    	boolean b = false;
    	try {
    	 	ret = (Boolean) TransAttribute.REQUIRED.invoke(_method, this, null);
    	 	b = isTx();
    	} finally {
    		TransactionManagerImpl.getInstance().commit();
    	}
    	assertEquals("2", false, isTx());
    	assertEquals("3", true, b);
    	assertEquals("4", true, ret.booleanValue());
    }
    
    public void testRequiresNew() throws Exception {
    	assertEquals("1", false, isTx());
    	Boolean ret = (Boolean) TransAttribute.REQUIRES_NEW.invoke(_method, this, null);
    	assertEquals("2", false, isTx());
    	assertEquals("3", true, ret.booleanValue());
    }
    
    public void testRequiresNew2() throws Exception {
    	assertEquals("1", false, isTx());
    	TransactionManagerImpl.getInstance().begin();
    	String xid = getXid();
    	String xid2 = null;
    	boolean b = false;
    	try {
    	 	xid2 = (String) TransAttribute.REQUIRES_NEW.invoke(_method2, this, null);
    	 	b = isTx();
    	} finally {
    		TransactionManagerImpl.getInstance().commit();
    	}
    	assertEquals("2", false, isTx());
    	assertEquals("3", true, b);
    	assertEquals("4", false, xid.equals(xid2));
    }
    
    public void testMandatory() throws Exception {
    	assertEquals("1", false, isTx());
    	TransactionManagerImpl.getInstance().begin();
    	Boolean ret = null;
    	boolean b = false;
    	try {
    	 	ret = (Boolean) TransAttribute.MANDATORY.invoke(_method, this, null);
    	 	b = isTx();
    	} finally {
    		TransactionManagerImpl.getInstance().commit();
    	}
    	assertEquals("2", false, isTx());
    	assertEquals("3", true, b);
    	assertEquals("4", true, ret.booleanValue());
    }
    
    public void testMandatory2() throws Exception {
    	assertEquals("1", false, isTx());
    	try {
    	 	TransAttribute.MANDATORY.invoke(_method, this, null);
    	 	fail("1");
    	} catch (Exception ex) {
    		System.out.println(ex);
    	}
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(TransAttributeTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{TransAttributeTest.class.getName()});
    }
}