package org.seasar.eclipse.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.seasar.eclipse.SeasarPlugin;

public final class NewSeasarProjectWizardPage extends WizardPage {
	
	private static final int TEXT_FIELD_WIDTH = 200;
	private static final String CONTEXT_PATH_LABEL_TEXT =
        SeasarPlugin.getResourceString("contextPath.label");
	
	private Text _contextPathText;
	private boolean _displayedOnce = false;

	public NewSeasarProjectWizardPage(String pageName) {
		super(pageName);
		setPageComplete(true);
	}

	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		createContextPathGroup(composite);
		setErrorMessage(null);
		setMessage(null);
		setControl(composite);	
	}


	public void createContextPathGroup(Composite parent) {
		Composite contextPathGroup = new Composite(parent,SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		contextPathGroup.setLayout(layout);
		contextPathGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		Label contextPathLabel = new Label(contextPathGroup,SWT.NONE);
		contextPathLabel.setText(CONTEXT_PATH_LABEL_TEXT);
		contextPathLabel.setEnabled(true);
		_contextPathText = new Text(contextPathGroup, SWT.BORDER);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.widthHint = TEXT_FIELD_WIDTH;
		_contextPathText.setLayoutData(data);
		_contextPathText.setText("");
		_contextPathText.setEnabled(true);
	}
		
	public String getContextPath() {
		return _contextPathText.getText();	
	}

	public void setContextPath(String contextPath) {
		_contextPathText.setText(contextPath);	
	}
	
	public boolean canFlipToNextPage() {
		_displayedOnce = true;
		return super.canFlipToNextPage();
	}

	public boolean isDisplayedOnce() {
		return _displayedOnce;
	}
}
