package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public class StmtTag extends AbstractRuleStatement {
	
	private Expression _exp;
	
	public StmtTag(Object parent, String location, Expression exp) {
		super(parent, location);
		Assertion.assertNotNull("exp", exp);
		_exp = exp;
	}
	
	public void execute(RuleContext ruleContext) throws SeasarException {
		try {
			_exp.evaluateValue(ruleContext);
		} catch (Throwable t) {
			ruleContext.setThrowable(t, getLocation());
		}
	}

}
