#include "seasar/lang/SObject.as"

if (seasar.event.Broadcaster === undefined) {
	var clazz = seasar.lang.SObject.defineClass("seasar.event.Broadcaster");
	clazz.__resolve = seasar.lang.SObject.__resolve;
	clazz.listeners = new Object();
	clazz.listenerId = 0;
	clazz.debug = function(funcName, data) {
		trace("Broadcaster " + funcName + ":" + data);
	}
	clazz.debugOff = function() {
		delete this.debug;
	}
	clazz.msgPump_mc = this.createEmptyMovieClip("msgPump_mc", 1);
	clazz.msgPump_mc.msg_array = new Array();
	clazz.msgPump_mc.onEnterFrame = function() {
		while (this.msg_array.length > 0) {
			var msg = this.msg_array.pop();
			var funcName = msg.event + "Performed";
			var func = msg.listener[funcName];
			if (func != undefined) {
				seasar.event.Broadcaster.debug(funcName, msg.data);
				func.call(msg.listener, msg.data);
			} else {
				trace(funcName + " not found");
			}
		}
	}

	clazz.addEventListener = function (event, listener) {
		var eventListeners = this.listeners[event];
		var id = this.listenerId++;
		if (eventListeners == undefined) {
			eventListeners = new Object();
			this.listeners[event] = eventListeners;
		}
		eventListeners[id] = listener;
		return id;
	}
	
	clazz.removeEventListener = function (event, listenerId) {
		var eventListeners = this.listeners[event];
		if (eventListeners != undefined) {
			delete eventListeners[listenerId];
		}
	}
	
	clazz.removeEventListeners = function (event) {
		delete this.listeners[event];
	}
	
	clazz.removeAllEventListener = function () {
		this.listeners = new Object();
	}
	
	clazz.getEventListener = function(event, listenerId) {
		var eventListeners = this.listeners[event];
		if (eventListeners != undefined) {
			return eventListeners[listenerId];
		} else {
			return undefined;
		}
	}
	
	clazz.broadcast = function (event, data) {
		var eventListeners = this.listeners[event];
		if (eventListeners != undefined) {
			for (id in eventListeners) {
				var obj = new Object();
				obj.listener = eventListeners[id];
				obj.event = event;
				obj.data = data;
				this.msgPump_mc.msg_array.push(obj);
			}
		} else {
			trace(event + ":listener not found");
		}
	}

	delete clazz;
}