#include "seasar/lang/SObject.as"
#include "seasar/unit/TestCase.as"
#include "seasar/event/Broadcaster.as"

if (test.seasar.event.BroadcasterTest === undefined) {
	seasar.lang.SObject.defineClass("test.seasar.event.BroadcasterTest",
		seasar.unit.TestCase, ["conn", "addService"]);
	
	var proto = test.seasar.event.BroadcasterTest.prototype;
	
	proto.setUp = function() {
	}
	
	proto.tearDown = function() {
	}
	
	proto.testGetEventListener = function() {
		var listener = new Object();
		var id = seasar.event.Broadcaster.addEventListener("hoge", listener);
		this.assertDefined("1", seasar.event.Broadcaster.getEventListener("hoge", id));
		this.assertUndefined("2", seasar.event.Broadcaster.getEventListener("xxx", id));
		this.assertUndefined("3", seasar.event.Broadcaster.getEventListener("hoge", -1));
	}
	
	proto.testAddEventListener = function() {
		var listener = new Object();
		var id = seasar.event.Broadcaster.addEventListener("hoge", listener);
		this.assertNotNull("1", id);
		this.assertDefined("2", seasar.event.Broadcaster.getEventListener("hoge", id));
	}
	
	proto.testRemoveEventListener = function() {
		var listener = new Object();
		var id = seasar.event.Broadcaster.addEventListener("hoge", listener);
		seasar.event.Broadcaster.removeEventListener("hoge", id);
		this.assertUndefined("1", seasar.event.Broadcaster.getEventListener("hoge", id));
	}
	
	proto.testRemoveEventListeners = function() {
		var listener = new Object();
		var id = seasar.event.Broadcaster.addEventListener("hoge", listener);
		seasar.event.Broadcaster.removeEventListeners("hoge");
		this.assertUndefined("1", seasar.event.Broadcaster.getEventListener("hoge", id));
	}
	
	proto.testBroadcast = function() {
		var listener = new Object();
		listener.hogePerformed = function(data) {
			trace("listener.hogePerformed:" + data);
		}
		listener.toString = function() {
			return "hogehoge";
		}
		var id = seasar.event.Broadcaster.addEventListener("hoge", listener);
		seasar.event.Broadcaster.broadcast("hoge", "aaa");
	}

	delete proto;
}