#include "NetServices.as"
#include "seasar/lang/SObject.as"
#include "seasar/unit/TestCase.as"
#include "seasar/nazuna/RuleEventService.as"
#include "seasar/event/Broadcaster.as"

if (test.seasar.nazuna.RuleEventServiceTest === undefined) {
	seasar.lang.SObject.defineClass("test.seasar.nazuna.RuleEventServiceTest",
		seasar.unit.TestCase, ["conn", "addService"]);
	
	test.seasar.nazuna.RuleEventServiceTest.ADD_RULET = "examples.org.seasar.nazuna.AddRulet";	
	var proto = test.seasar.nazuna.RuleEventServiceTest.prototype;
	
	proto.setUp = function() {
		NetServices.setDefaultGatewayUrl("http://localhost:8080/examples/gateway");
		this.conn = NetServices.createGatewayConnection();
		this.conn.onStatus = function(result) {
			trace(result.details);
		};
		this.addService = new seasar.nazuna.RuleEventService(this.conn,
			this.constructor.ADD_RULET, "hoge", "hogeStatus");
	}
	
	proto.tearDown = function() {
		this.conn = null;
		this.addService = null;
	}
	
	proto.testConstructor = function() {
		this.assertNotNull("1", this.addService.rule);
		this.assertEquals("2", this.constructor.ADD_RULET, this.addService.ruleName);
		this.assertEquals("3", "hoge", this.addService.resultEvent);
		this.assertEquals("4", "hogeStatus", this.addService.statusEvent);
	}
	
	proto.testExecuteRulet = function() {
		var listener = new Object();
		listener.hogePerformed = function(data) {
			trace("listener:" + data);
		}
		listener.hogeStatusPerformed = function(data) {
			trace(data.details);
		}
		seasar.event.Broadcaster.addEventListener("hoge", listener);
		this.addService.rule.executeRulet(1, 2);
	}

	delete proto;
}