#include "NetServices.as"
#include "seasar/lang/SObject.as"
#include "seasar/unit/TestCase.as"
#include "seasar/nazuna/RuleService.as"

if (test.seasar.nazuna.RuleServiceTest === undefined) {
	seasar.lang.SObject.defineClass("test.seasar.nazuna.RuleServiceTest",
		seasar.unit.TestCase, ["conn", "addService"]);
	
	test.seasar.nazuna.RuleServiceTest.ADD_RULET = "examples.org.seasar.nazuna.AddRulet";	
	var proto = test.seasar.nazuna.RuleServiceTest.prototype;
	
	proto.setUp = function() {
		NetServices.setDefaultGatewayUrl("http://localhost:8080/examples/gateway");
		this.conn = NetServices.createGatewayConnection();
		this.conn.onStatus = function(result) {
			trace(result.details);
		};
		this.addService = new seasar.nazuna.RuleService(this.conn, this.constructor.ADD_RULET);
	}
	
	proto.tearDown = function() {
		this.conn = null;
		this.addService = null;
	}
	
	proto.testConstructor = function() {
		this.assertNotNull("1", this.addService.rule);
		this.assertEquals("2", this.constructor.ADD_RULET, this.addService.ruleName);
	}
	
	proto.testExecuteRulet = function() {
		this.addService.rule.executeRulet(1, 2);
	}

	delete proto;
}