package org.seasar.expr;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public abstract class AbstractCalculateExp implements Expression {

	private final Expression _arg1Exp;
	private final Expression _arg2Exp;

	public AbstractCalculateExp(
		final Expression arg1Exp,
		final Expression arg2Exp) {

		Assertion.assertNotNull("arg1Exp", arg1Exp);
		Assertion.assertNotNull("arg2Exp", arg2Exp);

		_arg1Exp = arg1Exp;
		_arg2Exp = arg2Exp;
	}

	public final Number getArg1(ExprContext context) throws SeasarException {
		return (Number) _arg1Exp.evaluateValue(context);
	}

	public final Number getArg2(ExprContext context) throws SeasarException {
		return (Number) _arg2Exp.evaluateValue(context);
	}
}