package org.seasar.expr;

import java.util.Map;

import org.seasar.util.SMap;

public final class AliasConfigManager {

	private static Map _aliasConfigs = new SMap();

	private AliasConfigManager() {
	}

	public static AliasConfig resolveAlias(String name) {
		return (AliasConfig) _aliasConfigs.get(name);
	}

	public static void addAliasConfig(AliasConfig aliasConfig) {
		_aliasConfigs.put(aliasConfig.getName(), aliasConfig);
	}

	public static void removeAliasConfig(String name) {
		_aliasConfigs.remove(name);
	}
	
	public static void clear() {
		_aliasConfigs.clear();
	}
}
