package org.seasar.expr;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class AndExp implements BooleanExpression {

	private final BooleanExpression _arg1Exp;
	private final BooleanExpression _arg2Exp;

	public AndExp(BooleanExpression arg1Exp, BooleanExpression arg2Exp) {
		Assertion.assertNotNull("arg1Exp", arg1Exp);
		Assertion.assertNotNull("arg2Exp", arg2Exp);

		_arg1Exp = arg1Exp;
		_arg2Exp = arg2Exp;
	}

	public boolean evaluate(ExprContext context) throws SeasarException {
		if (!_arg1Exp.evaluate(context)) {
			return false;
		} else {
			return _arg2Exp.evaluate(context);
		}
	}
}
