package org.seasar.expr;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class CaseExp implements Expression {

	private BooleanExpression[] _boolExps;
	private Expression[] _exps;

	public CaseExp(
		final BooleanExpression[] boolExps,
		final Expression[] exps) {

		Assertion.assertNotNull("boolExps", boolExps);
		Assertion.assertNotNull("exps", exps);

		_boolExps = boolExps;
		_exps = exps;
	}

	public Object evaluateValue(ExprContext context) throws SeasarException {
		for (int i = 0; i < _boolExps.length; i++) {
			BooleanExpression be = _boolExps[i];
			if (be.evaluate(context)) {
				return _exps[i].evaluateValue(context);
			}
		}
		return null;
	}
}