package org.seasar.expr;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class CoalesceExp implements Expression {

	private final Expression[] _exps;

	public CoalesceExp(final Expression[] exps) {
		Assertion.assertNotNull("exps", exps);

		_exps = exps;
	}

	public Object evaluateValue(ExprContext context) throws SeasarException {
		for (int i = 0; i < _exps.length; i++) {
			Object o = _exps[i].evaluateValue(context);
			if (o != null) {
				return o;
			}
		}
		return null;
	}
}
