package org.seasar.expr;

import org.seasar.util.Assertion;
import org.seasar.util.Conversion;
import org.seasar.util.SeasarException;

public final class ConcatenateExp implements Expression {

	private final Expression[] _exps;

	public ConcatenateExp(final Expression[] exps) {
		Assertion.assertNotNull("exps", exps);

		_exps = exps;
	}

	public Object evaluateValue(ExprContext context) throws SeasarException {
		StringBuffer buf = new StringBuffer(100);
		for (int i = 0; i < _exps.length; ++i) {
			Expression exp = _exps[i];
			String arg = Conversion.toString(exp.evaluateValue(context), null);
			buf.append(arg);
		}
		return buf.toString();
	}
}
