package org.seasar.expr;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;

import org.seasar.util.Reflector;
import org.seasar.util.SMap;
import org.seasar.util.SeasarException;
import org.seasar.util.StringUtil;

public final class ExprUtil {

	private static Map _targetClasses = new SMap();

	static {
		_targetClasses.put(Integer.class, Integer.TYPE);
		_targetClasses.put(Long.class, Long.TYPE);
		_targetClasses.put(Double.class, Double.TYPE);
		_targetClasses.put(Float.class, Float.TYPE);
		_targetClasses.put(Boolean.class, Boolean.TYPE);
	}

	private ExprUtil() {
	}

	public static Expression[] toExpressionArray(List expList) {
		return (Expression[]) expList.toArray(new Expression[expList.size()]);
	}

	public static BooleanExpression[] toBooleanExpressionArray(List boolExpList) {
		return (BooleanExpression[]) boolExpList.toArray(
			new BooleanExpression[boolExpList.size()]);
	}

	public static Object[] evaluateValues(
		Expression[] exps,
		ExprContext context)
		throws SeasarException {

		Object[] args = new Object[exps.length];
		for (int i = 0; i < args.length; ++i) {
			args[i] = exps[i].evaluateValue(context);
		}
		return args;
	}

	public static boolean isTargetClass(Class paramClass, Class argClass) {
		if (paramClass == Object.class) {
			return true;
		}
		if (paramClass.isPrimitive()) {
			Class clazz = (Class) _targetClasses.get(argClass);
			if (clazz != null) {
				argClass = clazz;
			}
		}
		return paramClass.isAssignableFrom(argClass);
	}

	public static final Object getProperty(
		final Object target,
		final String propertyName)
		throws SeasarException {

		if (target instanceof Map) {
			return ((Map) target).get(propertyName);
		} else if (
			target.getClass().isArray() && "length".equals(propertyName)) {
			return new Integer(Array.getLength(target));
		} else {
			return Reflector.getProperty(target, propertyName);
		}
	}

	public static final void setProperty(
		final Object target,
		final String propertyName,
		final Object value)
		throws SeasarException {

		if (target instanceof Map) {
			((Map) target).put(propertyName, value);
		} else {
			Reflector.setProperty2(target, propertyName, value);
		}
	}

	public static boolean isClassName(String targetName) {
		int pos = targetName.lastIndexOf('.') + 1;
		return Character.isUpperCase(targetName.charAt(pos));
	}

	public static Class getClass(String className) {
		if (StringUtil.isEmpty(className)) {
			return Object.class;
		}
		if (className.endsWith("[]")) {
			className =
				"[L" + className.substring(0, className.length() - 2) + ";";
		}
		return Reflector.getClass(className);
	}

}
