package org.seasar.expr;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class IntegerExp implements Expression {

	private final Integer _value;

	public IntegerExp(Integer value) {
		Assertion.assertNotNull("value", value);

		_value = value;
	}

	public Object evaluateValue(ExprContext context) throws SeasarException {
		return _value;
	}
}