package org.seasar.expr;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class IsNotNullExp implements BooleanExpression {

	private Expression _targetExp;

	public IsNotNullExp(final Expression targetExp) {
		Assertion.assertNotNull("targetExp", targetExp);

		_targetExp = targetExp;
	}

	public boolean evaluate(ExprContext context) throws SeasarException {
		Object target = _targetExp.evaluateValue(context);
		if (target != null) {
			return true;
		} else {
			return false;
		}
	}
}
