package org.seasar.expr;

import org.seasar.util.Assertion;
import org.seasar.util.Conversion;
import org.seasar.util.Like;
import org.seasar.util.SeasarException;

public final class LikeExp implements BooleanExpression {

	private final Expression _targetExp;
	private final Expression _patternExp;

	public LikeExp(final Expression targetExp, final Expression patternExp) {
		Assertion.assertNotNull("targetExp", targetExp);
		Assertion.assertNotNull("patternExp", patternExp);

		_targetExp = targetExp;
		_patternExp = patternExp;
	}

	public boolean evaluate(ExprContext context) throws SeasarException {
		String target =
			Conversion.toString(_targetExp.evaluateValue(context), null);
		String pattern =
			Conversion.toString(_patternExp.evaluateValue(context), null);
		return Like.match(pattern, target);
	}
}
