package org.seasar.expr;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class LongExp implements Expression {

	private final Long _value;

	public LongExp(Long value) {
		Assertion.assertNotNull("value", value);

		_value = value;
	}

	public Object evaluateValue(final ExprContext context)
		throws SeasarException {

		return _value;
	}
}